<?php
	require_once('../include/config.php');
	require_once('../include/admin_function.php');
	require_once('./inc.php');
?>
<!DOCTYPE HTML>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
<meta name="format-detection" content="telephone=no">
<meta name="robots" content="noindex,nofollow" />
<title>新規登録</title>
<link rel="stylesheet" type="text/css" href="../css/style.css">
<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
<script type="text/javascript" src="../js/jquery.easing.1.3.js"></script>
<script type="text/javascript" src="../js/common.js"></script>
</head>
<body>
<div id="container" class="clearfix">
  <h1><?php echo $titleContents;?> 新規登録</h1>
  <div id="logoutBtn" class="linkBtn"><a href="?logout=true">ログアウト</a></div>
  <div id="toPage" class="linkBtn"><a href="./">一覧へ戻る</a></div>
  
  
  
<div id="contents" class="clearfix">
<div id="leftContents">
<?php 	require_once('../include/gnav.php');?>
</div> 
  
<div id="rightContents">
  
  
  <p>新規に登録します。必要事項を入力後、ページ下部の「登録」ボタンを押して下さい。</p>
  <form method="post" action="put.php" enctype="multipart/form-data" class="validateForm">
  
<?php
//トークンセット
$token = sha1(uniqid(mt_rand(), true));
$_SESSION['token'] = $token;
?>
<input type="hidden" name="token" value="<?php echo $token;//トークン発行?>" />
<input type="hidden" name="data[mode]" value="shinki" />
<input type="hidden" name="data[category]" value="" />
<input type="hidden" name="data[sort]" value="0" />
  
    <table class="borderTable01">
      <tr>
        <th>登録年月日</th>
        <td><?php echo registYmdList();//日付プルダウン表示?> ※未来の日付にした場合、設定日の0時～表示されます（表示予約機能）</td>
      </tr>
      <tr>
        <th>公開・非公開</th>
        <td>
          <input type="hidden" name="data[public_flag]" value="0" />
          <label><input type="checkbox" name="data[public_flag]" value="1" checked="checked" />（チェックで「公開」になります）</label></td>
      </tr>
      <?php if(!empty($categorySet['gallery'])){ ?>
      <tr>
        <th>カテゴリ</th>
        <td>
        <?php foreach($categorySet['gallery'] as $key => $val){ ?>
        <label><input type="radio" name="data[category]" value="<?php echo $key;?>" required /> <?php echo ghs(rpc($val));?></label>　
        <?php } ?>
        </td>
      </tr>
      <?php } ?>
      <tr>
        <th>タイトル</th>
        <td><input type="text" size="80" name="data[title]" value="" placeholder="" required /></td>
      </tr>
      <tr>
        <th>画像（5MB以内）</th>
        <td><input type="file" name="data[upfile][]" accept="image/*" /><br>「jpg／gif／png」がアップロードできます。</td>
      </tr>
      <tr>
        <td colspan="2"><p class="taC"><input type="submit" value="登録" class="submitBtn" /></p></td>
      </tr>
    </table>
    

  </form>
 <p class="pagetop linkBtn taR"><a href="#container">PAGE TOP▲</a></p>
</div>
</div>
</div>
</body>
</html>