<?php
	require_once('../include/config.php');
	require_once('../include/admin_function.php');
	require_once('./inc.php');
	
	$id = (!empty($_GET['id'])) ? ghs($_GET['id']) : exit('パラメータがありません');//IDをセット
	if(!is_num($id)) exit;
	if(isset($_POST['del_submit'])){
		
		//トークンチェック（CSRF対策）
		if(empty($_SESSION['token']) || ($_SESSION['token'] !== $_POST['token'])){
			exit('ページ遷移エラー(トークン)');
		}
		//トークン破棄
		$_SESSION['token'] = '';
		
		$id = (!empty($_POST['id'])) ? ghs($_POST['id']) : exit('パラメータがありません');	
		if(!is_num($id)) exit;
		
		$lines = file($file_path);
		$fp = fopen($file_path, "r+b") or die("ファイルオープンエラー");
		
		// 俳他的ロック
		if (flock($fp, LOCK_EX)) {
			ftruncate($fp,0);
			rewind($fp);
			foreach($lines as $val){
				$lines_array = explode(",",$val);
				if($lines_array[0] != $id){
				  fwrite($fp, $val);
				}
			}
		}
		  
		fflush($fp);
		flock($fp, LOCK_UN);
		fclose($fp);
		
		//アップファイル削除
		for($i=0;$i<$maxFileLimit;$i++){
			foreach($extensionList as $val){
				$upFilePath = $img_updir.'/'.$id.'-'.$i.'.'.$val;
				$upFilePathThumb = $img_updir.'/'.$id.'-'.$i.'s.'.$val;
				
				if(file_exists($upFilePath)){
					unlink($upFilePath);
				}
				if(file_exists($upFilePathThumb)){
					unlink($upFilePathThumb);
				}
			}
		}
		
	
	}else{
		$resDataArr = ID2Data($file_path,$id);
	}
?>
<!DOCTYPE HTML>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
<meta name="format-detection" content="telephone=no">
<meta name="robots" content="noindex,nofollow" />
<title>データ削除</title>
<link rel="stylesheet" type="text/css" href="../css/style.css">
<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.10.1/jquery.min.js"></script>
<script type="text/javascript" src="../js/jquery.easing.1.3.js"></script>
<script type="text/javascript" src="../js/common.js"></script>
</head>
<body>
<div id="container">
  <h1>データ削除</h1>
<div id="logoutBtn" class="linkBtn"><a href="?logout=true">ログアウト</a></div>
<div id="toPage" class="linkBtn"><a href="./">一覧へ戻る</a></div>

<div id="contents" class="clearfix">
<div id="leftContents">
<?php 	require_once('../include/gnav.php');?>
</div> 
  
<div id="rightContents">
<?php if(isset($_POST['del_submit'])){ ?>
<?php if(!empty($messe)) echo $messe; ?>
<p class="col19 big taC">削除が完了しました。</p> 
<?php }else{ ?>

<form method="post" action="">
<?php
//トークンセット
$token = sha1(uniqid(mt_rand(), true));
$_SESSION['token'] = $token;
?>
<input type="hidden" name="token" value="<?php echo $token;//トークン発行?>" />
<p class="taC">このデータを削除するには「このデータを削除する」をクリックしてください。（アップしたファイルも削除されます。）</p>
<p class="taC"><input type="button" onClick="history.back()" value="キャンセル" class="submitBtn" /> 
<input type="submit" name="del_submit" value="　このデータを削除する" class="submitBtn" /></p>
<input type="hidden" name="id" value="<?php echo $id;?>" />
</form>
  <table class="borderTable01">
    <tr>
      <th>登録年月日</th>
      <td align="left"><?php echo date2FormatDate($dateType,$resDataArr[1]);?></td>
      </tr>
  <tr>
	<th>公開・非公開</th>
    <td><?php echo $resDataArr[2] == 1 ? '公開':'非公開';?></td>
  </tr>
      <?php if(!empty($categorySet['gallery'])){ ?>
      <tr>
        <th>カテゴリ</th>
        <td><?php echo (!empty($categorySet['gallery'][$resDataArr[5]])) ? ghs(rpc($categorySet['gallery'][$resDataArr[5]])) : '';?></td>
      </tr>
      <?php } ?>
      <tr>
        <th>タイトル</th>
        <td><?php echo ghs(rpc($resDataArr[3]));?></td>
      </tr>
<?php 
	//ファイル存在判定と存在したらセット
	$upfileTag = '';
	foreach($extensionList as $val){
		$upFilePath = $img_updir.'/'.$resDataArr[0].'-0.'.$val;
		if(file_exists($upFilePath)){
			
			if($val == 'jpg' || $val == 'png' || $val == 'gif' || $val == 'webp'){
				$upfileTag .= "<img src=\"{$upFilePath}?".uniqid()."\" style='width:100%'>\n";
			}else{
				$upfileTag .= "<a href=\"{$upFilePath}\" target=\"_blank\">アップファイル</a>\n";
			}
			break;
		}
	}
?>
<tr>
<th>画像</th>
<td><?php echo $upfileTag;?></td>
</tr>

</table>


<p class="pagetop linkBtn taR"><a href="#container">PAGE TOP▲</a></p>
<?php } ?>
</div> 
</div>
</div>
</body>
</html>