<?php
/*

【CSS3使用版】
marqueeタグではなくCSS（CSS3）のみで対応したものです。スマホでの表示も想定している場合などはこちらをご使用下さい。
PCでもIE,Firefox、Chromeなど現在の主要なブラウザはほぼ対応しています。が、必ず複数の環境での確認を行って下さい。

既存のページに直接埋め込む場合には以下コメント箇所をコピペ下さい。
ただし拡張子が.phpである必要があります。

既存のページが.htmlで拡張子を変えたくない場合には、表示させたい場所にiframeでこのファイルを読み込んで下さい。
タグ例　<iframe src="telop.php" width="600" height="45" frameborder="0" scrolling="no"></iframe>

*/
?>
<!DOCTYPE HTML>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
<meta name="format-detection" content="telephone=no">
<title>テロップ</title>

<!--　▼▼▼既存のページ等に表示させる場合、必要に応じてコピペ下さい。CSSは自由に変更下さい　▼▼▼　-->
<style>
body { 
	margin:0;padding:0;
}
.telop{
	border:2px solid #666;
	padding:10px 10px;
	background:#222;
	border-radius:8px;
	margin:0 5px;
}
.telop span{
	color:#eee;
	font-size:13px;
	font-family:"メイリオ", Meiryo, Osaka, "ＭＳ Ｐゴシック", "MS PGothic", sans-serif;
}
.ymdText{
	margin-right:10px;
}
.telopText{
	margin-right:20px;
}
.telopText a{
	color:#eee;
}

/** マーキーさせたい部分 */
.marquee {
	overflow: hidden; /* スクロールバーが出ないように */
	position: relative; /* マーキーの内容部分の位置の基準になるように */
}
 /* マーキーの内容部分の高さ確保 */
.marquee::after {
  content: "";
  white-space: nowrap;
  display: inline-block;
}
/* マーキーさせたい部分(内側) */
.marquee > .marquee-inner {
  position: absolute;
  top: 0;
  white-space: nowrap;
  animation-name: marquee;
  animation-timing-function: linear;
  animation-duration: 20s;/*スピードです。数字が小さい＝早い。*/
  animation-iteration-count: infinite;
}
/* マウスオーバーでマーキーストップ */
.marquee > .marquee-inner:hover {
  animation-play-state: paused;
  cursor: default;
}
/** マーキーアニメーション */
@keyframes marquee {
    0% { left: 100%; transform: translate(0); }
  100% { left: 0; transform: translate(-100%); }
}
</style>
<!-- ▲▲▲コピペここまで▲▲▲ -->

</head>
<body>

<!--　▼▼▼　表示させたい場所に以下すべてをコピペ下さい（拡張子が.phpである必要があります）　▼▼▼　-->
<?php 
include_once("admin/include/config.php");//設定ファイルの読み込み
if(!$copyright){echo $warningMesse;exit;}else{
//埋め込み先の文字コード（「UTF-8」,「EUC-JP」,「SJIS」（Shift_JIS）のいずれかで指定下さい）
$encodingType = 'UTF-8';
$lines = telop_dataListSortUser(file($file_path),$encodingType);//ファイルの内容を取得
foreach($lines as $val){
	$linesArr = explode(',',$val);
	$telop .= ($dsp_date == 1) ? '<span class="ymdText">【 '.telop_ymd2format(h($linesArr[1])).' 】</span>' : '';//日付
	$telop .= '<span class="telopText">'.telop_title_format($linesArr[0],$linesArr[2],$linesArr[4]).'</span>';//内容
}
$telop .= (!empty($telop)) ? telop_Wrg8TGHYw($encodingType) : '';
//以下タグは自由に変更下さい。(「scrollamount="○○"」属性でスピードを変更可能。数値大→速い)
?>
<div class="telop"><div class="marquee"><div class="marquee-inner"><?php echo $telop;?></div></div></div>
<?php } ?>

<!-- ▲▲▲　コピペここまで　▲▲▲ -->


</body>
</html>